<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../../componenti/include/includeBaseComponenti.php";
    // solo i super admin hanno accesso agli strumenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Amministrazione di Geecom CMS - strumento backup</title>

    <?php
        include "../../componenti/include/cssBaseComponenti.php";
    ?>
	  
  </head>
  <body>
    
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
    ?>
	  
    <main role="main" class="bg-light" id="main">
        <div id="dashboard" class="container-fluid">
            <div class="row">
                <div class="col-xl-8 mx-auto py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header" >
                            <span class="card-title">Backup </span>
                        </div>
                        <?php 
                            $backup= scandir("../../../file/backup");
                        ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6 col-lg-2 mb-5 mb-lg-0 text-center">
                                        <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaFileSito">
                                            <img src="../../../template/img/dash/icona_dash_Archivio.svg" class="w-50 mb-3">
                                            <h6>Tutti i File</h6>
                                        </a>
                                    </div>
                                    <div class="col-6 col-lg-2 mb-5 mb-lg-0 text-center">
                                        <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaImmaginiSito">
                                            <img src="../../../template/img/dash/icona_dash_Immagini.svg" class="w-50 mb-3">
                                            <h6>Immagini</h6>
                                        </a>
                                    </div>
                                    <div class="col-6 col-lg-2 mb-5 mb-lg-0 text-center">
                                        <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaRisorse">
                                            <img src="../../../template/img/dash/icona_dash_Risorse.svg" class="w-50 mb-3">
                                            <h6>Risorse</h6>
                                        </a>
                                    </div>
                                    <div class="col-6 col-lg-2 mb-5 mb-lg-0 text-center">
                                        <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaDatabase">
                                            <img src="../../../template/img/dash/icona_dash_Database.svg" class="w-50 mb-3">
                                            <h6>Database</h6>
                                        </a>
                                    </div>
                                </div>
                                
                                <hr>
                                <ul class="nav nav nav-tabs tabs-justified mt-3">
                                    <li class="nav-item">
                                          <a class="nav-link"  data-toggle="tab" href="#tabFile" role="tab" aria-controls="tabFile">Tutti i file</a>
                                    </li>
                                    <li class="nav-item">
                                          <a class="nav-link"  data-toggle="tab" href="#tabRisorse" role="tab" aria-controls="tabRisorse">Risorse</a>
                                    </li>
                                    <li class="nav-item">
                                          <a class="nav-link" data-toggle="tab" href="#tabImmagini" role="tab" aria-controls="tabImmagini">Immagini</a>
                                    </li>
                                    <li class="nav-item">
                                          <a class="nav-link active" data-toggle="tab" href="#tabDatabase" role="tab" aria-controls="tabDatabase">Contenuti</a>
                                    </li>
                                </ul>
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active px-0" id="tabDatabase">
                                        <table class="table">
                                              <thead>
                                                  <tr>
                                                      <th scope="col">#</th>
                                                      <th scope="col">Nome file</th>
                                                      <th scope="col">Data</th>
                                                      <th scope="col"></th>
                                                  </tr>
                                              </thead>
                                              <tbody>
                                                <?php 
                                                    foreach($backup as $file) {
                                                        if($file!="." && $file!=".." && strpos($file,"database")>0) {
                                                ?>
                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td><?php echo $file ?></td>
                                                            <td><?php echo date("d/m/Y H:i", filemtime("../../../file/backup/$file")); ?></td>
                                                            <td>
                                                                <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                    <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/backup/$file" ?>"><i class="fas fa-download"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                <?php
                                                        }
                                                    }
                                                ?>

                                              </tbody>
                                        </table>
                                    </div>

                                    <div class="tab-pane fade px-0" id="tabFile">
                                              <table class="table">
                                                <thead>
                                                      <tr>
                                                        <th scope="col">#</th>
                                                        <th scope="col">Nome file</th>
                                                        <th scope="col">Data</th>
                                                        <th scope="col"></th>
                                                      </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                        foreach($backup as $file) {
                                                            if($file!="." && $file!=".." && strpos($file,"file")>0) {
                                                    ?>
                                                            <tr>
                                                                <th scope="row">1</th>
                                                                <td><?php echo $file ?></td>
                                                                <td><?php echo date("d/m/Y H:i", filemtime("../../../file/backup/$file")); ?></td>
                                                                <td>
                                                                    <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                        <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/backup/$file" ?>"><i class="fas fa-download"></i></a>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                    <?php
                                                            }
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                    </div>
                                    <div class="tab-pane fade px-0" id="tabRisorse">
                                              <table class="table">
                                                <thead>
                                                      <tr>
                                                        <th scope="col">#</th>
                                                        <th scope="col">Nome file</th>
                                                        <th scope="col">Data</th>
                                                        <th scope="col"></th>
                                                      </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                        foreach($backup as $file) {
                                                            if($file!="." && $file!=".." && strpos($file,"risorse")>0) {
                                                    ?>
                                                            <tr>
                                                                <th scope="row">1</th>
                                                                <td><?php echo $file ?></td>
                                                                <td><?php echo date("d/m/Y H:i", filemtime("../../../file/backup/$file")); ?></td>
                                                                <td>
                                                                    <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                        <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/backup/$file" ?>"><i class="fas fa-download"></i></a>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                    <?php
                                                            }
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                    </div>
                                    
                                    <div class="tab-pane fade px-0" id="tabImmagini">
                                              <table class="table">
                                                <thead>
                                                      <tr>
                                                        <th scope="col">#</th>
                                                        <th scope="col">Nome file</th>
                                                        <th scope="col">Data</th>
                                                        <th scope="col"></th>
                                                      </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                        foreach($backup as $file) {
                                                            if($file!="." && $file!=".." && strpos($file,"Immagini")>0) {
                                                    ?>
                                                            <tr>
                                                                <th scope="row">1</th>
                                                                <td><?php echo $file ?></td>
                                                                <td><?php echo date("d/m/Y H:i", filemtime("../../../file/backup/$file")); ?></td>
                                                                <td>
                                                                    <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                        <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/backup/$file" ?>"><i class="fas fa-download"></i></a>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                    <?php
                                                            }
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                    </div>
                                </div>
                            </div>
                    </div>
                </div><!-- /Colonna principale -->
            </div>
        </div>
    </main>
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
                
        include "../../componenti/include/jsBaseComponenti.php";
    ?>
	  
  </body>
</html>
